<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:wnio="http://piu.mpips.pl/rd/ZS_6/1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" version="1.0" xsi:schemaLocation="http://www.w3.org/1999/XSL/Transform http://www.w3.org/2007/schema-for-xslt20.xsd">
  <xsl:template match="/">
    <html>
      <head>
        <title>ZS-6 (Formularz) - Ministerstwo Pracy i Polityki Społecznej</title>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"></meta>
      </head>
      <body style="text-align: center; font-family: Arial; ">
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; page-break-after: always; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZS-6</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 6px; " class="SofLabel page"></span>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 25px; " class="SofHRule">
              <span></span>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 212px; " class="SofLabel global14Bold">JEDNOSTKA ORGANIZACYJNA</div>
          <div style="position: absolute; height: 101px; width: 880px; left: 0px; top: 229px; ">
            <div style="position: absolute; height: 101px; width: 100%; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 0px; " class="SofBorderContainer lightGrayAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 6px; " class="SofLabel sectionHeader">JEDNOSTKA ORGANIZACYJNA WŁAŚCIWA DO PROWADZENIA POSTĘPOWANIA W SPRAWIE (1)</div>
              <div style="position: absolute; height: 68px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; line-height: 20px; height: 54px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 7px; " class="SofTextArea dotted">
                  <div style="padding-left:5px ; padding-top:2px; display: block;">
                    <xsl:call-template name="formatTextArea">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:JednostkaOrganizacyjnaProwadzacaPostepowanie"></xsl:with-param>
                      <xsl:with-param name="wysokosc" select="54"></xsl:with-param>
                      <xsl:with-param name="szerokosc" select="865"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="wysokoscLini" select="20"></xsl:with-param>
                      <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0"></xsl:with-param>
                      <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:JednostkaOrganizacyjnaProwadzacaPostepowanie"></xsl:with-param>
                    </xsl:call-template>
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 233px; width: 880px; left: 0px; top: 329px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 0px; " class="SofBorderContainer lightGrayAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 6px; " class="SofLabel sectionHeader">ADRES JEDNOSTKI ORGANIZACYJNEJ WŁAŚCIWEJ DO PROWADZENIA POSTĘPOWANIA W SPRAWIE (1)</div>
              <div style="position: absolute; height: 200px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 47px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresJednostkiProwadzacejPostepowanie/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresJednostkiProwadzacejPostepowanie/wnio:KodPocztowy, 1, 2)"></xsl:value-of>
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresJednostkiProwadzacejPostepowanie/wnio:KodPocztowy, 3, 4)"></xsl:value-of>
                    </xsl:if>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 171px; top: 47px; " class="SofLabel">03. Miejscowość</div>
                <div style="position: absolute; height: 25px; text-align: left; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 673px; font-size: 18px; background-color: white; display: block; left: 171px; border: 1px solid black; top: 62px; " class="SofTextInput dotted">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresJednostkiProwadzacejPostepowanie/wnio:Miejscowosc"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 3px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresJednostkiProwadzacejPostepowanie/wnio:GminaDzielnica"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 91px; " class="SofLabel">04. Ulica</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresJednostkiProwadzacejPostepowanie/wnio:Ulica"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 135px; " class="SofLabel">05. Numer domu</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresJednostkiProwadzacejPostepowanie/wnio:NumerDomu"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 195px; top: 135px; " class="SofLabel">06. Numer lokalu</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 195px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresJednostkiProwadzacejPostepowanie/wnio:NumerLokalu"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 4px; top: 181px; " class="SofLabel">(1) Wójt, burmistrz lub prezydent miasta właściwy ze względu na miejsce zamieszkania osoby uprawnionej.</div>
              </div>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 577px; " class="SofLabel global14Bold">DANE OSOBY SKŁADAJĄCEJ PISMO / DANE OSOBY, KTÓREJ DOTYCZY PISMO</div>
          <div style="position: absolute; height: 274px; width: 880px; left: 0px; top: 594px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 0px; " class="SofBorderContainer lightGrayAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 10px; font-weight: bold; top: 6px; " class="SofLabel sectionHeader">DANE IDENTYFIKACYJNE OSOBY</div>
              <div style="position: absolute; height: 240px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; width: 123px; font-size: 12px; left: 3px; top: 3px; " class="SofLabel">01. Numer PESEL (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 265px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneOsoby/wnio:PESEL"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 137px; font-size: 12px; left: 291px; top: 3px; " class="SofLabel">02. Rodzaj dokumentu tożsamości: jeśli dowód osobisty, wpisać 1, jeśli inny - 2</div>
                <div style="position: absolute; height: 27px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 48px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 435px; border: 1px solid black; top: 18px; " class="SofDropDownList">
                  <span style="padding-left: 5px;display: block;line-height:27px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneOsoby/wnio:RodzajDokumentu"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="48"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 856px; font-size: 12px; left: 4px; top: 181px; " class="SofLabel">(1) Należy wpisać numer PESEL, a jeżeli nie nadano tego numeru, należy wpisać serię i numer dowodu osobistego lub innego dokumentu potwierdzającego tożsamość.</div>
                <div style="position: absolute; color: #000000; width: 790px; font-size: 12px; left: 4px; top: 208px; " class="SofLabel">(2) Wypełnić w przypadku, gdy obywatelstwo jest inne niż polskie.</div>
                <div style="position: absolute; color: #000000; width: 790px; font-size: 12px; left: 4px; top: 222px; " class="SofLabel">(3) Podanie symbolu państwa nie jest konieczne, jeżeli wniosek jest zgłaszany w formie papierowej.</div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 507px; top: 3px; " class="SofLabel">03. Seria i numer dokumentu</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 361px; font-size: 18px; background-color: white; display: block; left: 507px; border: 1px solid black; top: 18px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneOsoby/wnio:NumerDokumentu"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 47px; " class="SofLabel">04. Nazwisko</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneOsoby/wnio:Nazwisko"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 91px; " class="SofLabel">05. Imię</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 721px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneOsoby/wnio:Imie"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 603px; top: 135px; " class="SofLabel">07. Symbol państwa (2)(3)</div>
                <div style="position: absolute; height: 27px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 72px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 603px; border: 1px solid black; top: 150px; " class="SofDropDownList dictionary">
                  <span style="padding-left: 5px;display: block;line-height:27px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneOsoby/wnio:SymbolPanstwa"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="72"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 3px; top: 135px; " class="SofLabel">06. Obywatelstwo (nazwa państwa) (2)</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 552px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofComboBox dictionary">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:DaneIdentyfikacyjneOsoby/wnio:Obywatelstwo"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="552"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 348px; width: 880px; left: 0px; top: 867px; ">
            <div style="position: absolute; height: 100%; width: 100%; border-style: solid; background-color: #E7E5E6; border-color: #E7E5E6; left: 0px; border-width: 0px; top: 0px; " class="SofBorderContainer lightGrayAll">
              <div style="position: absolute; color: #000000; font-size: 12px; left: 11px; font-weight: bold; top: 6px; " class="SofLabel sectionHeader">DANE ADRESOWE OSOBY - ADRES ZAMIESZKANIA</div>
              <div style="position: absolute; height: 315px; width: 870px; background-color: #ffffff; left: 10px; top: 23px; " class="SofBorderContainer">
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 47px; " class="SofLabel">02. Kod pocztowy</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 145px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 62px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;display: block;">
                    <xsl:if test="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:KodPocztowy!= ''">
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:KodPocztowy, 1, 2)"></xsl:value-of>
                      -
                      <xsl:value-of select="substring(//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:KodPocztowy, 3, 4)"></xsl:value-of>
                    </xsl:if>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 171px; top: 47px; " class="SofLabel">03. Miejscowość</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 673px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 171px; border: 1px solid black; top: 62px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:Miejscowosc"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="673"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 3px; " class="SofLabel">01. Gmina / Dzielnica</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 18px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:GminaDzielnica"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 91px; " class="SofLabel">04. Ulica</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 3px; border: 1px solid black; top: 106px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:Ulica"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 135px; " class="SofLabel">05. Numer domu</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:NumerDomu"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 195px; top: 135px; " class="SofLabel">06. Numer lokalu</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 169px; font-size: 18px; background-color: white; display: block; left: 195px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:NumerLokalu"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 126px; font-size: 12px; left: 411px; top: 135px; " class="SofLabel">07. Numer telefonu</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 241px; font-size: 18px; background-color: white; display: block; left: 411px; border: 1px solid black; top: 150px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:NumerTelefonu"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 160px; font-size: 12px; left: 699px; top: 135px; " class="SofLabel">08. Symbol państwa (2)(3)</div>
                <div style="position: absolute; height: 27px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 72px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 699px; border: 1px solid black; top: 150px; " class="SofDropDownList dictionary">
                  <span style="padding-left: 5px;display: block;line-height:27px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:SymbolPanstwa"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="72"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 189px; font-size: 12px; left: 3px; top: 179px; " class="SofLabel">09. Zagraniczny kod pocztowy (2)</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 289px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 194px; " class="SofTextInput">
                  <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                    <xsl:value-of select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:ZagranicznyKodPocztowy"></xsl:value-of>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 457px; font-size: 12px; left: 315px; top: 179px; " class="SofLabel">10. Nazwa państwa (2)</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 547px; font-size: 18px; background-color: white; border-color: #696969; display: block; left: 315px; border: 1px solid black; top: 194px; " class="SofComboBox dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:NazwaPanstwa"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="547"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; font-size: 12px; left: 3px; top: 223px; " class="SofLabel">11. Adres poczty elektronicznej (1)</div>
                <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 3px; border: 1px solid black; top: 238px; " class="SofTextInput dotted">
                  <span style="padding-left: 5px;display: block;line-height:25px;">
                    <xsl:call-template name="redukcjaCzcionki">
                      <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:AdresZamieszkaniaOsoby/wnio:AdresPocztyElektronicznej"></xsl:with-param>
                      <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                      <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
                    </xsl:call-template>
                  </span>
                </div>
                <div style="position: absolute; color: #000000; width: 790px; font-size: 12px; left: 4px; top: 269px; " class="SofLabel"></div>
                <div style="position: absolute; color: #000000; width: 790px; font-size: 12px; left: 4px; top: 282px; " class="SofLabel">(2) Wypełnić w przypadku, gdy adres jest inny niż polski.</div>
                <div style="position: absolute; color: #000000; width: 790px; font-size: 12px; left: 4px; top: 295px; " class="SofLabel">(3) Podanie symbolu państwa nie jest konieczne, jeżeli wniosek jest zgłaszany w formie papierowej.</div>
              </div>
            </div>
          </div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 1px; " class="SofLabel footnote">wersja: ZS-6(1)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 1px; " class="SofLabel footnote">strona: 1/2</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 1px; " class="SofHRule">
              <span></span>
            </div>
          </div>
          <div style="position: absolute; height: 80px; text-align: center; color: #000000; width: 100%; font-size: 16px; left: 0px; font-weight: bold; top: 78px; " class="SofLabel formTitle">
            KORESPONDENCJA
            <br></br>
            W &#xa0;SPRAWIE
            <br></br>
            DO &#xa0;JEDNOSTKI &#xa0;TERENOWEJ
          </div>
        </div>
        <div style="position: relative; margin-right: auto; height: 1280px; text-align: left; overflow: hidden; width: 880px; margin-left: auto; background-color: white; margin-bottom: 15px; margin-top: 15px; border: 1px solid black; ">
          <div style="position: absolute; height: 26px; width: 880px; left: 0px; top: 0px; ">
            <div style="position: absolute; height: 24px; text-align: right; color: #000000; width: 545px; font-size: 20px; left: 322px; font-weight: bold; top: 0px; " class="SofLabel formName">ZS-6</div>
            <span style="position: absolute; height: 14px; color: #000000; width: 300px; font-size: 12px; left: 5px; font-weight: normal; top: 6px; " class="SofLabel page"></span>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 25px; " class="SofHRule">
              <span></span>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: normal; top: 63px; " class="SofLabel global14Normal">Sprawa z dnia:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 108px; top: 43px; " class="SofLabel">Data (dd / mm / rrrr)</div>
          <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: solid; display: block; left: 109px; border: 1px solid black; top: 58px; " class="SofDateField">
            <span style="padding-left:5px ; line-height:25px; display: block;">
              <xsl:call-template name="formatDaty">
                <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:DataSprawy"></xsl:with-param>
              </xsl:call-template>
            </span>
            <span></span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 324px; font-family: arial; font-weight: normal; top: 63px; " class="SofLabel global14Normal">nr:</div>
          <div style="position: absolute; color: #000000; font-size: 12px; left: 349px; top: 43px; " class="SofLabel">Podać sygnaturę i nr sprawy:</div>
          <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 526px; font-size: 18px; background-color: white; display: block; left: 349px; border: 1px solid black; top: 58px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:SygnaturaNumerSprawy"></xsl:with-param>
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                <xsl:with-param name="dlugoscPolaWPikselach" select="526"></xsl:with-param>
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 6px; font-family: arial; font-weight: bold; top: 112px; " class="SofLabel global14Bold">TREŚĆ KORESPONDENCJI:</div>
          <div style="position: absolute; line-height: 20px; height: 741px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 865px; font-size: 18px; background-color: white; display: block; left: 8px; border: 1px solid black; top: 134px; " class="SofTextArea dotted">
            <div style="padding-left:5px ; padding-top:2px; display: block;">
              <xsl:call-template name="formatTextArea">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:TrescKorespondencji"></xsl:with-param>
                <xsl:with-param name="wysokosc" select="741"></xsl:with-param>
                <xsl:with-param name="szerokosc" select="865"></xsl:with-param>
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                <xsl:with-param name="wysokoscLini" select="20"></xsl:with-param>
                <xsl:with-param name="liczbaPrzejscDoNowychLini" select="0"></xsl:with-param>
                <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini" select="//wnio:TrescDokumentu/wnio:TrescKorespondencji"></xsl:with-param>
              </xsl:call-template>
            </div>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 945px; " class="SofLabel global14Normal">Załączniki:</div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 972px; " class="SofLabel global14Normal">1)</div>
          <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 32px; border: 1px solid black; top: 967px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik1"></xsl:with-param>
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 1004px; " class="SofLabel global14Normal">2)</div>
          <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 32px; border: 1px solid black; top: 999px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik2"></xsl:with-param>
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 1035px; " class="SofLabel global14Normal">3)</div>
          <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 32px; border: 1px solid black; top: 1030px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik3"></xsl:with-param>
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; color: #000000; font-size: 14px; left: 8px; font-family: arial; font-weight: normal; top: 1066px; " class="SofLabel global14Normal">4)</div>
          <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 841px; font-size: 18px; background-color: white; display: block; left: 32px; border: 1px solid black; top: 1061px; " class="SofTextInput dotted">
            <span style="padding-left: 5px;display: block;line-height:25px;">
              <xsl:call-template name="redukcjaCzcionki">
                <xsl:with-param name="tekst" select="//wnio:TrescDokumentu/wnio:ZalaczoneDokumenty/wnio:Zalacznik4"></xsl:with-param>
                <xsl:with-param name="bazowyRozmiarCzcionki" select="18"></xsl:with-param>
                <xsl:with-param name="dlugoscPolaWPikselach" select="841"></xsl:with-param>
              </xsl:call-template>
            </span>
          </div>
          <div style="position: absolute; height: 52px; width: 869px; left: 8px; top: 1148px; ">
            <div style="position: absolute; height: 52px; width: 100%; background-color: #ffffff; left: 0px; top: 0px; " class="SofBorderContainer">
              <div style="position: absolute; height: 14px; color: #000000; width: 84px; font-size: 12px; left: 374px; top: 38px; " class="SofLabel">(Miejscowość)</div>
              <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 457px; font-size: 18px; background-color: white; display: block; left: 203px; border: 1px solid black; top: 6px; " class="SofTextInput dotted">
                <span style="padding-left:5px ;line-height:25px;padding-right: 5px; display: block;">
                  <xsl:value-of select="//wnio:TrescDokumentu/wnio:Miejscowosc"></xsl:value-of>
                </span>
              </div>
              <div style="position: absolute; height: 25px; color: #000000; default-background-color: #ffffff; overflow: hidden; width: 191px; font-size: 18px; background-color: white; border-style: dotted; display: block; left: 669px; border: 1px solid black; top: 6px; " class="SofDateField dotted">
                <span style="padding-left:5px ; line-height:25px; display: block;">
                  <xsl:call-template name="formatDaty">
                    <xsl:with-param name="wartosc" select="//wnio:TrescDokumentu/wnio:Data"></xsl:with-param>
                  </xsl:call-template>
                </span>
                <span></span>
              </div>
              <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 190px; font-size: 12px; left: 655px; top: 38px; " class="SofLabel">(Data: dd / mm / rrrr)</div>
            </div>
          </div>
          <div style="position: absolute; height: 16px; width: 880px; left: 0px; top: 1223px; ">
            <div style="position: absolute; height: 14px; text-align: right; color: #000000; width: 300px; font-size: 11px; left: 559px; font-family: verdana; top: 1px; " class="SofLabel footnote">wersja: ZS-6(1)</div>
            <div style="position: absolute; height: 14px; text-align: center; color: #000000; width: 850px; font-size: 11px; left: 10px; font-family: verdana; top: 1px; " class="SofLabel footnote">strona: 2/2</div>
            <div style="position: absolute; height: 1px; width: 100%; left: 0px; border-top: 1px solid black; top: 1px; " class="SofHRule">
              <span></span>
            </div>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
  <xsl:template match="wnio:Informacja1//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."></xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja2//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."></xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja3//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."></xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template match="wnio:Informacja4//*">
    <xsl:call-template name="Info">
      <xsl:with-param name="node" select="."></xsl:with-param>
    </xsl:call-template>
  </xsl:template>
  <xsl:template name="Info">
    <xsl:choose>
      <xsl:when test="name(.) = 'TextFlow'">
        <xsl:apply-templates></xsl:apply-templates>
      </xsl:when>
      <xsl:when test="name(.) = 'br'">
        <xsl:choose>
          <xsl:when test="name(..) = 'dl'">
            <xsl:apply-templates></xsl:apply-templates>
          </xsl:when>
          <xsl:otherwise>
            <xsl:element name="{name(.)}">
              <xsl:apply-templates></xsl:apply-templates>
            </xsl:element>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:element name="{name(.)}">
          <xsl:for-each select="@*">
            <xsl:attribute name="{name(.)}">
              <xsl:value-of select="."></xsl:value-of>
            </xsl:attribute>
          </xsl:for-each>
          <xsl:apply-templates></xsl:apply-templates>
        </xsl:element>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionki">
    <xsl:param name="tekst"></xsl:param>
    <xsl:param name="bazowyRozmiarCzcionki"></xsl:param>
    <xsl:param name="dlugoscPolaWPikselach"></xsl:param>
    <xsl:variable name="dlugoscTekstuWPikselach">
      <!-- chodzi o makstylana dlugosc - przypadek kiedy caly tekst skladal sie z liter 'W' -->
      <xsl:value-of select="string-length($tekst) * $bazowyRozmiarCzcionki"></xsl:value-of>
    </xsl:variable>
    <xsl:variable name="roznicaDlugosciTekstuIPolaWPikselach">
      <xsl:value-of select="$dlugoscTekstuWPikselach - $dlugoscPolaWPikselach"></xsl:value-of>
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$roznicaDlugosciTekstuIPolaWPikselach &lt; 0">1</xsl:when>
        <xsl:otherwise>
          <xsl:variable name="ulamekOJakiZmniejszamyCzcionke">
            <xsl:value-of select="($roznicaDlugosciTekstuIPolaWPikselach div $dlugoscTekstuWPikselach)"></xsl:value-of>
          </xsl:variable>
          <xsl:value-of select="1 - $ulamekOJakiZmniejszamyCzcionke"></xsl:value-of>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <span>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'em')"></xsl:value-of>
      </xsl:attribute>
      <xsl:value-of select="$tekst"></xsl:value-of>
    </span>
  </xsl:template>
  <xsl:template name="formatDaty">
    <xsl:param name="wartosc"></xsl:param>
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 9, 2)"></xsl:value-of>
      /
      <xsl:value-of select="substring($wartosc, 6, 2)"></xsl:value-of>
      /
      <xsl:value-of select="substring($wartosc, 1, 4)"></xsl:value-of>
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatKoduPocztowego">
    <xsl:param name="wartosc"></xsl:param>
    <xsl:if test="$wartosc != ''">
      <xsl:value-of select="substring($wartosc, 1, 2)"></xsl:value-of>
      -
      <xsl:value-of select="substring($wartosc, 3, 4)"></xsl:value-of>
    </xsl:if>
  </xsl:template>
  <xsl:template name="formatTextArea">
    <xsl:param name="tekst"></xsl:param>
    <xsl:param name="wysokosc"></xsl:param>
    <xsl:param name="szerokosc"></xsl:param>
    <xsl:param name="bazowyRozmiarCzcionki"></xsl:param>
    <xsl:param name="wysokoscLini"></xsl:param>
    <xsl:param name="liczbaPrzejscDoNowychLini"></xsl:param>
    <xsl:param name="tekstPoOstatnimPrzejsciuDoNowejLini"></xsl:param>
    <xsl:choose>
      <xsl:when test="contains($tekstPoOstatnimPrzejsciuDoNowejLini,'&#xA;')">
        <xsl:call-template name="formatTextArea">
          <xsl:with-param name="tekst" select="$tekst"></xsl:with-param>
          <xsl:with-param name="wysokosc" select="$wysokosc"></xsl:with-param>
          <xsl:with-param name="szerokosc" select="$szerokosc"></xsl:with-param>
          <xsl:with-param name="bazowyRozmiarCzcionki" select="$bazowyRozmiarCzcionki"></xsl:with-param>
          <xsl:with-param name="wysokoscLini" select="$wysokoscLini"></xsl:with-param>
          <xsl:with-param name="liczbaPrzejscDoNowychLini" select="$liczbaPrzejscDoNowychLini + 1"></xsl:with-param>
          <xsl:with-param name="tekstPoOstatnimPrzejsciuDoNowejLini">
            <xsl:value-of select="substring-after($tekstPoOstatnimPrzejsciuDoNowejLini,'&#xA;')"></xsl:value-of>
          </xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="redukcjaCzcionkiTextArea">
          <xsl:with-param name="tekst" select="$tekst"></xsl:with-param>
          <xsl:with-param name="wysokosc" select="$wysokosc"></xsl:with-param>
          <xsl:with-param name="szerokosc" select="$szerokosc"></xsl:with-param>
          <xsl:with-param name="bazowyRozmiarCzcionki" select="$bazowyRozmiarCzcionki"></xsl:with-param>
          <xsl:with-param name="wysokoscLini" select="$wysokoscLini"></xsl:with-param>
          <xsl:with-param name="liczbaPrzejscDoNowychLini" select="$liczbaPrzejscDoNowychLini"></xsl:with-param>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="redukcjaCzcionkiTextArea">
    <xsl:param name="tekst"></xsl:param>
    <xsl:param name="wysokosc"></xsl:param>
    <xsl:param name="szerokosc"></xsl:param>
    <xsl:param name="bazowyRozmiarCzcionki"></xsl:param>
    <xsl:param name="wysokoscLini"></xsl:param>
    <xsl:param name="liczbaPrzejscDoNowychLini"></xsl:param>
    <xsl:variable name="liczbaLini">
      <xsl:value-of select="floor((string-length($tekst) * $bazowyRozmiarCzcionki) div $szerokosc) + $liczbaPrzejscDoNowychLini"></xsl:value-of>
    </xsl:variable>
    <xsl:variable name="liczbaLiniKtoraSieMiesci">
      <xsl:value-of select="ceiling($wysokosc div $wysokoscLini)"></xsl:value-of>
    </xsl:variable>
    <xsl:variable name="roznicaLiczyLini">
      <xsl:value-of select="$liczbaLini - $liczbaLiniKtoraSieMiesci"></xsl:value-of>
    </xsl:variable>
    <xsl:variable name="docelowyRozmiarCzcionki">
      <xsl:choose>
        <xsl:when test="$roznicaLiczyLini &lt; 0">1</xsl:when>
        <xsl:otherwise>
          <xsl:variable name="ulamekOJakiZmniejszamyCzcionke">
            <xsl:value-of select="$liczbaLini div $liczbaLiniKtoraSieMiesci"></xsl:value-of>
          </xsl:variable>
          <xsl:value-of select="1 div $ulamekOJakiZmniejszamyCzcionke"></xsl:value-of>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:variable>
    <xsl:variable name="docelowaWysokoscLini">
      <xsl:value-of select="($wysokoscLini * $docelowyRozmiarCzcionki)"></xsl:value-of>
    </xsl:variable>
    <div>
      <xsl:attribute name="style">
        <xsl:value-of select="concat('font-size:', $docelowyRozmiarCzcionki, 'em;', 'line-height:', $docelowaWysokoscLini, 'px; word-wrap : break-word;')"></xsl:value-of>
      </xsl:attribute>
      <!--<xsl:value-of select="substring-before($tekst,'&#xA;')"></xsl:value-of> -->
      <xsl:call-template name="podzialTekstuWTextArea">
        <xsl:with-param name="tekst" select="$tekst"></xsl:with-param>
        <xsl:with-param name="docelowyRozmiarCzcionki" select="$docelowyRozmiarCzcionki"></xsl:with-param>
        <xsl:with-param name="docelowaWysokoscLini" select="$docelowaWysokoscLini"></xsl:with-param>
      </xsl:call-template>
    </div>
  </xsl:template>
  <xsl:template name="podzialTekstuWTextArea">
    <xsl:param name="tekst"></xsl:param>
    <xsl:param name="docelowyRozmiarCzcionki"></xsl:param>
    <xsl:param name="docelowaWysokoscLini"></xsl:param>
    <xsl:choose>
      <xsl:when test="contains($tekst,'&#xA;')">
        <div>
          <xsl:value-of select="substring-before($tekst,'&#xA;')"></xsl:value-of>
        </div>
        <xsl:call-template name="podzialTekstuWTextArea">
          <xsl:with-param name="tekst" select="substring-after($tekst,'&#xA;')"></xsl:with-param>
          <xsl:with-param name="docelowyRozmiarCzcionki" select="$docelowyRozmiarCzcionki"></xsl:with-param>
          <xsl:with-param name="docelowaWysokoscLini" select="$docelowaWysokoscLini"></xsl:with-param>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <div>
          <xsl:value-of select="$tekst"></xsl:value-of>
        </div>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
